function imgBinary = applyThreshold_slow(img, T)
% Threshold a grayscale image such that all pixels greater than or equal to
% T are 1. Otherwise, pixel is 0.
%
% INPUTS:
%   img - The input grayscale image. Must be of the size M-by-N.
%   T - The threshold. Must be a scalar between 0 and 255.
%
% OUTPUT:
%   imgBinary - The result of thresholding. A binary image (each pixel is
%               either 1 or 0).

M = size(img, 1);
N = size(img, 2);
imgBinary = zeros(M,N);   %pre-allocate space for output

for i = 1:M
    for j = 1:N
        if img(i,j) >= T
            imgBinary(i,j) = 1;
        else
            imgBinary(i,j) = 0; 
        end
    end
end

end

